#!/usr/bin/wish
# Generated code: Mon Mar 10 10:19:28 EDT 2014
# Generated by: $Id: CTCPanelWindow.tcl 709 2009-05-01 15:20:49Z heller $
# Add your code to the bottom (after the 'Add User code after this line').
#
# -name {Example 1: Simple siding on single track mainline}
# -width 780
# -height 550
# -hascmri yes
# -cmriport /dev/ttyS1
# -cmrispeed 9600
# -cmriretries 10000
# -hasazatrax no
# -simplemode no
# additionalPackages
# Load Tcl/Tk system supplied packages
package require Tk;#		Make sure Tk is loaded
package require tile;#          Load tile
package require snit;#		Load Snit

# Load MRR System packages
# Add MRR System package Paths
lappend auto_path /usr/local/lib/MRRSystem;# C++ (binary) packages
lappend auto_path /usr/local/share/MRRSystem;# Tcl (source) packages

package require snitStdMenuBar;#  Load the standard menu bar package
package require LabelFrames;#   Label frame widgets
package require MainFrame;#     Main Frame widget
package require ScrollableFrame;#     Scrollable Frame widget
package require MainWindow;#    Load the Main Window package
package require CTCPanel 2.0;#  Load the CTCPanel package (V2)
package require grsupport 2.0;# Load Graphics Support code (V2)

#* 
#* ------------------------------------------------------------------
#* panelCode.tcl - Panel Main Window Creation Library
#* Created by Robert Heller on Sun Apr 13 18:27:24 2008
#* ------------------------------------------------------------------
#* Modification History: $Log$
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Model RR System, Version 2
#*     Copyright (C) 1994,1995,2002-2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

# $Id: panelCode.tcl 625 2008-04-21 23:39:05Z heller $

snit::type MainWindow {
  pragma -hastypeinfo    no
  pragma -hastypedestroy no
  pragma -hasinstances   no

  typecomponent main
  typecomponent swframe
  typecomponent ctcpanel

  delegate typemethod {ctcpanel *} to ctcpanel
  delegate typemethod {main *} to main
  typemethod createwindow {args} {
    set name [from args -name {}]
    set width [from args -width 800]
    set height [from args -height 800]
    wm protocol . WM_DELETE_WINDOW [mytypemethod CarefulExit]
    wm withdraw .
    wm title . "$name"
    set main [mainwindow .main]
    pack $main -expand yes -fill both
    $main menu entryconfigure file New -state disabled
    $main menu entryconfigure file Open... -state disabled
    $main menu entryconfigure file Save -state disabled
    $main menu entryconfigure file {Save As...} -state disabled
    $main menu entryconfigure file Print... -state disabled
    $main menu entryconfigure file Close -command [mytypemethod CarefulExit]
    $main menu entryconfigure file Exit -command [mytypemethod CarefulExit]
    set frame [$main scrollwindow getframe]
    set swframe [ScrollableFrame $frame.swframe \
			-constrainedheight yes -constrainedwidth yes \
			-width [expr {$width + 15}] -height $height]
    $main scrollwindow setwidget $swframe
    set ctcpanel [::CTCPanel::CTCPanel [$swframe getframe].ctcpanel \
			-width $width -height $height]
    pack $ctcpanel -fill both -expand yes
    $main menu add view command \
		-label {Zoom In} \
		-accelerator {+} \
		-command "$ctcpanel zoomBy 2"
    set zoomMenu [menu [$main mainframe getmenu view].zoom -tearoff no]
    $main menu add view cascade \
		-label Zoom \
		-menu $zoomMenu
    $main menu add view command \
		-label {Zoom Out} \
		-accelerator {-} \
		-command "$ctcpanel zoomBy .5"
    $zoomMenu add command -label {16:1} -command "$ctcpanel setZoom 16"
    $zoomMenu add command -label {8:1} -command "$ctcpanel setZoom 8"
    $zoomMenu add command -label {4:1} -command "$ctcpanel setZoom 4"
    $zoomMenu add command -label {2:1} -command "$ctcpanel setZoom 2"
    $zoomMenu add command -label {1:1} -command "$ctcpanel setZoom 1"
    $zoomMenu add command -label {1:2} -command "$ctcpanel setZoom .5"
    $zoomMenu add command -label {1:4} -command "$ctcpanel setZoom .25"
    $zoomMenu add command -label {1:8} -command "$ctcpanel setZoom .125"
    $zoomMenu add command -label {1:16} -command "$ctcpanel setZoom .0625"

    $main showit
  }
  typemethod CarefulExit {{answer no}} {
    if {!$answer} {
      set answer [tk_messageBox -default no -icon question \
			-message {Really Quit?} -title {Careful Exit} \
			-type yesno -parent $main]
      if {$answer} {exit}
    }
  }  
}

MainWindow createwindow -name {Example 1: Simple siding on single track mainline} -width 780 -height 550
# CTCPanelObjects
MainWindow ctcpanel create CodeButton CDB1 \
	-x 130.0 \
	-y 198.0 \
	-controlpoint CP1 \
	-command {::ControlPoints::CP1 code}
MainWindow ctcpanel create SIGPlate SGP1 \
	-x 131.0 \
	-y 137.0 \
	-label 1 \
	-controlpoint CP1 \
	-leftcommand {::SignalPlates::SGP1 setlever left} \
	-centercommand {::SignalPlates::SGP1 setlever center} \
	-rightcommand {::SignalPlates::SGP1 setlever right}
MainWindow ctcpanel create SWPlate SWP1 \
	-x 132.0 \
	-y 55.0 \
	-label 1 \
	-controlpoint CP1 \
	-normalcommand {::SwitchPlates::SWP1 setlever normal} \
	-reversecommand {::SwitchPlates::SWP1 setlever reverse}
MainWindow ctcpanel create CodeButton CDB2 \
	-x 335.0 \
	-y 198.0 \
	-controlpoint CP2 \
	-command {::ControlPoints::CP2 code
}
MainWindow ctcpanel create SIGPlate SGP2 \
	-x 335 \
	-y 137.0 \
	-label 1 \
	-controlpoint CP2 \
	-leftcommand {::SignalPlates::SGP2 setlever left} \
	-centercommand {::SignalPlates::SGP2 setlever center} \
	-rightcommand {::SignalPlates::SGP2 setlever right}
MainWindow ctcpanel create SWPlate SWP2 \
	-x 335.0 \
	-y 55.0 \
	-label 2 \
	-controlpoint CP2 \
	-normalcommand {::SwitchPlates::SWP2 setlever normal
} \
	-reversecommand {::SwitchPlates::SWP2 setlever reverse
}
MainWindow ctcpanel create StraightBlock Side1 \
	-x1 158.0 \
	-y1 120.0 \
	-x2 300.0 \
	-y2 120.0 \
	-controlpoint Main \
	-label {Siding 1} \
	-position above \
	-occupiedcommand {::Blocks::SD1 occupiedp
}
MainWindow ctcpanel create StraightBlock BK1 \
	-x1 15.0 \
	-y1 140.0 \
	-x2 108.0 \
	-y2 140.0 \
	-controlpoint Main \
	-label BK1 \
	-position below \
	-occupiedcommand {::Blocks::BK1 occupiedp}
MainWindow ctcpanel create StraightBlock BK3 \
	-x1 159.0 \
	-y1 140.0 \
	-x2 300.0 \
	-y2 140.0 \
	-controlpoint Main \
	-label BK3 \
	-position below \
	-occupiedcommand {::Blocks::BK3 occupiedp
}
MainWindow ctcpanel create StraightBlock BK4 \
	-x1 352.0 \
	-y1 140.0 \
	-x2 486.0 \
	-y2 140.0 \
	-controlpoint Main \
	-label BK4 \
	-position below \
	-occupiedcommand {::Blocks::BK4 occupiedp
}
MainWindow ctcpanel create Switch S1 \
	-x 113.0 \
	-y 140.0 \
	-label 1 \
	-controlpoint CP1 \
	-orientation 0 \
	-flipped yes \
	-statecommand {::Switches::S1 getstate} \
	-occupiedcommand {::Switches::S1 occupiedp
}
MainWindow ctcpanel create Switch S2 \
	-x 346.0 \
	-y 140.0 \
	-label 2 \
	-controlpoint CP2 \
	-orientation 4 \
	-flipped no \
	-statecommand {::Switches::S2 getstate} \
	-occupiedcommand {::Switches::S2 occupiedp

}
#* 
#* ------------------------------------------------------------------
#* cmriCode.tcl - CM/RI Library
#* Created by Robert Heller on Sun Apr 13 18:02:03 2008
#* ------------------------------------------------------------------
#* Modification History: $Log$
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Model RR System, Version 2
#*     Copyright (C) 1994,1995,2002-2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

# $Id: cmriCode.tcl 680 2009-01-07 22:53:14Z heller $

package require Cmri 2.0.0 ;#          Load the CMR/I package.
package require grsupport 2.0

# Snit type to implement a CMR/I node. 
snit::type CMriNode {
  typecomponent CMriBusObject;#		CMR/I I/O object
  typeconstructor {set CMriBusObject {}}
  typemethod open {port speed retries} {
    set CMriBusObject [CMri %%AUTO%% $port -baud  $speed -maxtries $retries]
  }
  typemethod close {} {
    if {[string length "$CMriBusObject"] > 0} {$CMriBusObject destroy}
    set CMriBusObject {}
  }
  # Define the integer verify method.
  GRSupport::VerifyIntegerMethod
  # options used by CMR/I nodes.
  option -ns -default 0 -readonly yes \
	 -validatemethod _VerifyInteger
  option -ni -default 0 -readonly yes \
	 -validatemethod _VerifyInteger
  option -no -default 0 -readonly yes \
	 -validatemethod _VerifyInteger
  option -dl -default 0 -readonly yes \
	 -validatemethod _VerifyInteger
  option -ct -default {} -readonly yes
  variable UA;#				This node's address
    
  constructor {_UA NodeType args} {
    cmri::uatype $_UA;#			Validate the address
    set UA $_UA;#			Stash our address
    $self configurelist $args;#		configure options
    # Determine type of node.
    cmri::CardType validate $NodeType;#	Validate the card type
    switch -exact -- $NodeType {
      SUSIC {set ctype SUSIC}
      USIC  {set ctype USIC}
      SMINI {set ctype SMINI
	     set options(-ni) 3
	     set options(-no) 6
	     set options(-dl) 0}
      default {
	error "Unknown Node Type: $NodeType"
      }
    }
    # Initialize our board.
    $CMriBusObject InitBoard $options(-ct) $options(-ni) \
			       $options(-no) $options(-ns) \
			       $UA $ctype $options(-dl)
  }
  # Input method -- poll our input ports
  method inputs {} {
    return [$CMriBusObject Inputs $options(-ni) $UA]
  }
  # Output method -- write to our output ports
  method outputs {args} {
    return [$CMriBusObject Outputs $args $UA]
  }
}


  


CMriNode open /dev/ttyS1 9600 10000
# CMRIBoards
CMriNode create CP1_2 0 SMINI -ns 0 -ni 3 -no 6 -dl 0 -ct {}

# Add User code after this line

# This is an example CTC Panel program.  It features a section of single
# tracked mainline with a passing siding.
#
# The switches and signals are controled by a SMINI node, which also connects
# occupation detectors and switch point sensors to the host system.
# See example1.iow for the I/O connections for this example.
#
# The signals are two headed, two light signals.
#

package require snit;#		Make sure snit is loaded.

# Define types:
# This code uses SNIT to create a set of OO types to encapsulate each of 
# the several elements of the system: trackwork sections (blocks), 
# switches (turnouts), Switch Plates, Signal Plates, Signals, and control
# points.
#

namespace eval Blocks {
  # Block type (general trackwork).
  # Encapsulates block occupation detectors.
  #
  snit::type Block {
    # Occupation state values
    typevariable OCC 1
    typevariable CLR 0
    # Occupation state bit
    variable occupiedbit
    constructor {} {
      set occupiedbit $CLR;#	Initialize to clear.
    }
    # Occupation state methods
    method occupiedp {} {return [expr {$occupiedbit == $OCC}]}
    method setoccupied {value} {
      set occupiedbit $value
    }
  }
  Block BK1;#	Block 1
  Block SD1;#	Siding
  Block BK3;#	Block 3
  Block BK4;#	Block 4
}

namespace eval Switches {
  # Switch type (turnout)
  # Encapsulates a switch (turnout), including its OS (delegated to a Block 
  # object), its switch motor, and its point position sensor (its state).
  snit::type Switch {
    component block;#			OS section
    delegate method * to block;#	Delegate block methods
    variable state unknown;#		Sense state (point position)
    # Motor bit values
    typevariable NOR 1;# 01		
    typevariable REV 2;# 10		
    variable motor;#			Motor bits -- used to drive switch 
#					motor.
    constructor {} {
      #					Install OS section
      install block using Blocks::Block %AUTO%
      # Initialize motor bits
      set motor $NOR
    }
    # State methods
    method getstate {} {return $state}
    method setstate {statebits} {
      if {$statebits == $NOR} {
        set state normal
      } elseif {$statebits == $REV} {
	set state reverse
      } else {
	set state unknown
      }
    }
    # Motor bit methods
    method motorbits {} {return $motor}
    method setmotor {mv} {
      switch -exact $mv {
	normal {set motor $NOR}
	reverse {set motor $REV}
      }
    }
  }
  Switch S1;#		Switch 1
  Switch S2;#		Switch 2
}


namespace eval SwitchPlates {
  # Switch Plate
  # Encapsulates a switch plate, implementing its lever position.
  snit::type SwitchPlate {
    component switch
    delegate method * to switch
    variable leverpos unknown
    constructor {sw} {
      set switch $sw
    }
    method setlever {pos} {set leverpos $pos}
    method getlever {} {return $leverpos}
  }
  SwitchPlate SWP1 Switches::S1
  SwitchPlate SWP2 Switches::S2
}

namespace eval Signals {
  # Signal types.  Encapsulates a signal's aspect.
  snit::type OneHead {
    # Single head signals have three states: dark, green or red.
    typevariable aspects -array {
      Dark	0x00
      Green	0x01
      Red	0x02
    }
    variable aspectbits
    constructor {} {
      set aspectbits $aspects(Dark)
    }
    method setaspect {a} {set aspectbits $aspects($a)}
    method getaspect {}  {return $aspectbits}
  }
  snit::type TwoHead {
    # Two head signals have four states: dard, green over red, red over green, 
    # and red over red.
    typevariable aspects -array {
      Dark	0x00
      GreenRed	0x06
      RedGreen	0x09
      RedRed	0x0A
    }
    variable aspectbits
    constructor {} {
      set aspectbits $aspects(Dark)
    }
    method setaspect {a} {set aspectbits $aspects($a)}
    method getaspect {}  {return $aspectbits}
  }
  TwoHead CP1E;#	Heading into switch 1 from the west (block 1)
  TwoHead CP1WM;#	Heading into switch 1 from the east on the main
  TwoHead CP1WS;#	Heading into switch 1 from the east from the siding
  TwoHead CP2EM;#	Heading into switch 2 from the west on the main
  TwoHead CP2ES;#	Heading into switch 2 from the west from the siding
  TwoHead CP2W;#	Heading into switch 2 from the east (block 4)
}

namespace eval SignalPlates {
  # Signal Plate, encapsulating a signal plate with its lever and indicators.
  snit::type SignalPlate {
    variable leverpos unknown
    option -signalplate -default {} -readonly yes
    constructor {args} {
      $self configurelist $args
    }
    method setlever {pos} {set leverpos $pos}
    method getlever {} {return $leverpos}
    method setdot {dir} {
      switch $dir {
	left {
	  MainWindow ctcpanel seti $options(-signalplate) L on
	  MainWindow ctcpanel seti $options(-signalplate) C off
	  MainWindow ctcpanel seti $options(-signalplate) R off
	}
	right {
	  MainWindow ctcpanel seti $options(-signalplate) L off
	  MainWindow ctcpanel seti $options(-signalplate) C off
	  MainWindow ctcpanel seti $options(-signalplate) R on
	}
	none -
	default {
	  MainWindow ctcpanel seti $options(-signalplate) L off
	  MainWindow ctcpanel seti $options(-signalplate) C on
	  MainWindow ctcpanel seti $options(-signalplate) R off
	}
      }
    }
  }
  SignalPlate SGP1 -signalplate SGP1;#	Signal plate for control point 1
  SignalPlate SGP2 -signalplate SGP2;#	Signal plate for control point 2
}

namespace eval ControlPoints {
  # Control points.  Used to implement code buttons.  
  # Encapsulates a control point
  snit::type ControlPoint {
    option -cpname -readonly yes -default {}
    constructor {args} {
      $self configurelist $args
    }
    method code {} {
      foreach swp [MainWindow ctcpanel objectlist $options(-cpname) SwitchPlates] {
	MainWindow ctcpanel invoke $swp
      }      
      foreach sgp [MainWindow ctcpanel objectlist $options(-cpname) SignalPlates] {
	MainWindow ctcpanel invoke $sgp
      }
    }
  }
  ControlPoint CP1 -cpname CP1;#	Control point 1
  ControlPoint CP2 -cpname CP2;#	Control point 2
}


# Main Loop Start
while {true} {
  # Read all ports
  set CP1_2_inbits [CP1_2 inputs]
  # Occupation Detectors: (Input Port A)
  set tempByte [lindex $CP1_2_inbits 0]
  Blocks::BK1  setoccupied [expr {$tempByte      & 0x01}]
  Switches::S1 setoccupied [expr {$tempByte >> 1 & 0x01}]
  Blocks::BK3  setoccupied [expr {$tempByte >> 2 & 0x01}]
  Blocks::SD1  setoccupied [expr {$tempByte >> 3 & 0x01}]
  Switches::S2 setoccupied [expr {$tempByte >> 4 & 0x01}]
  Blocks::BK4  setoccupied [expr {$tempByte >> 5 & 0x01}]
  # Switch point state switches (Input Port B)
  set tempByte [lindex $CP1_2_inbits 1]
  Switches::S1 setstate [expr {$tempByte      & 0x03}]
  Switches::S2 setstate [expr {$tempByte >> 2 & 0x03}]
  # Invoke all trackwork and get occupicency
  MainWindow ctcpanel invoke Side1
  MainWindow ctcpanel invoke BK1
  MainWindow ctcpanel invoke BK3
  MainWindow ctcpanel invoke BK4
  # Initialize all signals to Red
  Signals::CP1E setaspect RedRed
  Signals::CP1WM setaspect RedRed
  Signals::CP1WS setaspect RedRed
  Signals::CP2EM setaspect RedRed
  Signals::CP2ES setaspect RedRed
  Signals::CP2W setaspect RedRed
  set dot1 none;# Assume no direction of travel through control point 1
  if {![MainWindow ctcpanel invoke S1]} {
    # Switch1 OS is clear.  We can start to move the points
    Switches::S1 setmotor [SwitchPlates::SWP1 getlever]
    # get current point state
    switch [Switches::S1 getstate] {
      normal {;# Aligned for the Main.  Set the mainline signals.
	if {![Blocks::BK1 occupiedp] && 
	    [string equal [SignalPlates::SGP1 getlever] "left"]} {
	  # Clear to left
	  Signals::CP1WM setaspect GreenRed
	  set dot1 left
	}
        if {![Blocks::BK3 occupiedp] && 
	    [string equal [SignalPlates::SGP1 getlever] "right"]} {
	  # Clear to right
	  Signals::CP1E setaspect GreenRed
	  set dot1 right
        }
	# Set plate indicators
	MainWindow ctcpanel seti SWP1 N on
        MainWindow ctcpanel seti SWP1 R off
      }
      reverse {;# Aligned for the siding.  Set siding signals
	if {![Blocks::BK1 occupiedp] &&
	    [string equal [SignalPlates::SGP1 getlever] "left"]} {
	  # Clear to left
	  Signals::CP1WS setaspect RedGreen
	  set dot1 left  
	}
        if {![Blocks::SD1 occupiedp] &&
	    [string equal [SignalPlates::SGP1 getlever] "right"]} {
	  # Clear to right
	  Signals::CP1E setaspect RedGreen
	  set dot1 right
        }
	# Set plate indicators
	MainWindow ctcpanel seti SWP1 R on
	MainWindow ctcpanel seti SWP1 N off
      }
      default {;# Points still moving.
	# Set plate indicators
	MainWindow ctcpanel seti SWP1 R off
	MainWindow ctcpanel seti SWP1 N off
      }
    }
  }
  # Set DOT on switch plate
  SignalPlates::SGP1 setdot $dot1
  # Switch 2 is much the same.
  set dot2 none
  if {![MainWindow ctcpanel invoke S2]} {
    Switches::S2 setmotor [SwitchPlates::SWP2 getlever]
    switch [Switches::S2 getstate] {
      normal {
	if {![Blocks::BK4 occupiedp] &&
	    [string equal [SignalPlates::SGP2 getlever] "right"]} {
	  Signals::CP2EM setaspect GreenRed
	  set dot2 right
	}
        if {![Blocks::BK3 occupiedp] &&
	    [string equal [SignalPlates::SGP2 getlever] "left"]} {
	  Signals::CP2W setaspect GreenRed
	  set dot2 left
        }
	MainWindow ctcpanel seti SWP2 N on
	MainWindow ctcpanel seti SWP2 R off
      }
      reverse {
	if {![Blocks::BK4 occupiedp] &&
	    [string equal [SignalPlates::SGP2 getlever] "right"]} {
	  Signals::CP2ES setaspect RedGreen
	  set dot2 right
	}
        if {![Blocks::SD1 occupiedp] &&
	    [string equal [SignalPlates::SGP2 getlever] "left"]} {
	  Signals::CP2W setaspect RedGreen
	  set dot2 left
        }
	MainWindow ctcpanel seti SWP2 R on
	MainWindow ctcpanel seti SWP2 N off
      }
      default {
	MainWindow ctcpanel seti SWP2 R off
	MainWindow ctcpanel seti SWP2 N off
      }
    }
  }
  SignalPlates::SGP2 setdot $dot2
  # Approach lighting -- darken signals facing empty blocks.
  if {![Blocks::BK1 occupiedp]} {
    Signals::CP1E setaspect Dark
  }
  if {![Blocks::BK3 occupiedp]} {
    Signals::CP1WM setaspect Dark
    Signals::CP2EM setaspect Dark
  }
  if {![Blocks::SD1 occupiedp]} {
    Signals::CP1WS setaspect Dark
    Signals::CP2ES setaspect Dark
  }
  if {![Blocks::BK4 occupiedp]} {
    Signals::CP2W setaspect Dark
  }
  # Pack output bits
  # Output Port A Card 0(CP1E and CP1WM)
  set CP1_2_outbits [expr {[Signals::CP1E  getaspect] | \
			   [Signals::CP1WM getaspect] << 4}]
  # Output Port B Card 0 (CP1WS and S1)
  lappend CP1_2_outbits [expr {[Signals::CP1WS getaspect] | \
			       [Switches::S1   motorbits] << 4}]
  # Output Port C Card 0 (CP2EM and CP2ES)
  lappend CP1_2_outbits [expr {[Signals::CP2EM getaspect] | \
			       [Signals::CP2ES getaspect] << 4}]
  # Output Port A Card 2 (CP2W and S2)
  lappend CP1_2_outbits [expr {[Signals::CP2W getaspect] | \
  			       [Switches::S2  motorbits] << 4}]
  lappend CP1_2_outbits 0 0;# Output Ports B and C Card 2are not used.
#  puts stderr "*** CP1_2_outbits = $CP1_2_outbits"
  # Write all output ports
  eval [list CP1_2 outputs] $CP1_2_outbits
  update;# Update display
}
# Main Loop End


